#include <GUIConstantsEx.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>
#include <GUIListView.au3>
#include <HtmlSelector.au3>

Global $sHTML = '', $sURL = '', $aResult[1][5] = [[0]]
Global $fLoadHtml_XPath = True, $fLoadHtml_CSS = True

;Init all (XPath and CSS) selectors
Global $iHSEL_INIT = _HTMLSelector_Init($HSEL_INIT_ALLSEL)
Global $iHSEL_ERROR = @error

If Not $iHSEL_INIT And $iHSEL_ERROR = 3 Then
	MsgBox(16, 'Error', 'Unable to initialize HtmlSelector' & @CRLF & @CRLF & 'OK ==> EXIT')
	Exit
EndIf

$hGUI = GUICreate('HTMLSelector Example', 700, 600)

$iFirstCtrlID = GUICtrlCreateDummy() + 1

GUICtrlCreateLabel('Select from Html:', 20, 20)
$iSelect_Input = GUICtrlCreateInput('', 20, 40, 600, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_NOHIDESEL))
GUICtrlSendMsg($iSelect_Input, $EM_SETCUEBANNER, 0, 'Example: //div[@id="mydiv"]')
$iSelect_Bttn = GUICtrlCreateButton('Select', 630, 40, 50, 20, $BS_DEFPUSHBUTTON)
GUICtrlSetState(-1, $GUI_FOCUS)

$iXPath_Radio = 0
$iCSS_Radio = 0

Switch $iHSEL_ERROR
	Case 0
		$iXPath_Radio = GUICtrlCreateRadio('XPath Selector', 30, 70)
		$iCSS_Radio = GUICtrlCreateRadio('CSS Selector', 150, 70)
		GUICtrlSetState($iXPath_Radio, $GUI_CHECKED)
	Case 1
		$iCSS_Radio = GUICtrlCreateRadio('CSS Selector', 30, 70)
		GUICtrlSetState($iCSS_Radio, $GUI_CHECKED)
	Case 2
		$iXPath_Radio = GUICtrlCreateRadio('XPath Selector', 30, 70)
		GUICtrlSetState($iXPath_Radio, $GUI_CHECKED)
EndSwitch

GUICtrlCreateLabel('Result:', 20, 100)
$iResult_LV = GUICtrlCreateListView('#|OuterHtml|InnerHtml|InnerText', 20, 120, 660, 200, _
	BitOR($LVS_SHOWSELALWAYS, $LVS_SINGLESEL, $LVS_NOSORTHEADER), BitOR($LVS_EX_GRIDLINES, $LVS_EX_FULLROWSELECT))

GUICtrlCreateLabel('Status:', 350, 100, 40, 20)
GUICtrlSetFont(-1, 9, 800)
$iStatus_Lbl = GUICtrlCreateLabel('', 400, 101, 280, 20)

$iGetAttribs_Bttn = GUICtrlCreateButton('Get Attributes', 600, 322, 80, 20)

GUICtrlCreateLabel('Html:', 20, 330)
$iHtml_Edit = GUICtrlCreateEdit('', 20, 350, 660, 210, BitOR($ES_WANTRETURN, $WS_VSCROLL, $ES_AUTOVSCROLL, $ES_NOHIDESEL, $ES_READONLY))
GUICtrlSetBkColor(-1, 0xFFFFFF)

$iLoadHtml_Bttn = GUICtrlCreateButton('Load html...', 20, 570, 80, 20)

$iLastCtrlID = GUICtrlCreateDummy() - 1

GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()
	
	Switch $nMsg
		Case 0
			
		Case $GUI_EVENT_CLOSE
			GUIDelete($hGUI)
			Exit
		Case $iSelect_Bttn, $iXPath_Radio, $iCSS_Radio
			$sSelect = GUICtrlRead($iSelect_Input)
			$fIsXPath = (BitAND(GUICtrlRead($iXPath_Radio), $GUI_CHECKED) = $GUI_CHECKED)
			
			If $sHTML = '' Or $sSelect = '' Then
				ContinueLoop
			EndIf
			
			$fIsUTF8 = _Encoding_IsUTF8Format($sHTML)
			
			_StatusSet('Selecting...', 0x0000FF, 0)
			_CtrlsSetState($GUI_DISABLE)
			_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($iResult_LV))
			
			If $fIsXPath Then
				$aResult = _HtmlSelector_SelectByXPath($sHTML, $sSelect, -1, -1, $fLoadHtml_XPath)
				$fLoadHtml_XPath = False
			Else
				$aResult = _HtmlSelector_SelectByCSS($sHTML, $sSelect, -1, -1, $fLoadHtml_CSS)
				$fLoadHtml_CSS = False
			EndIf
			
			$iError = @error
			
			If $iError Then
				If $fIsXPath Then
					$iError = 'XPath.Sel.Err: ' & $iError
				Else
					$iError = 'CSS.Sel.Err: ' & $iError
				EndIf
				
				_StatusSet('Selection Error (' & $iError & ')', 0xFF0000)
				_CtrlsSetState($GUI_ENABLE)
				
				ContinueLoop
			EndIf
			
			For $i = 1 To $aResult[0][0]
				If $fIsUTF8 Or Not $fIsXPath Then
					$aResult[$i][$HSEL_RSLT_OUTERHTML] = BinaryToString(StringToBinary($aResult[$i][$HSEL_RSLT_OUTERHTML]), 4)
					$aResult[$i][$HSEL_RSLT_INNERHTML] = BinaryToString(StringToBinary($aResult[$i][$HSEL_RSLT_INNERHTML]), 4)
					$aResult[$i][$HSEL_RSLT_INNERTEXT] = BinaryToString(StringToBinary($aResult[$i][$HSEL_RSLT_INNERTEXT]), 4)
				EndIf
				
				$iIndex = _GUICtrlListView_InsertItem($iResult_LV, $i)
				_GUICtrlListView_AddSubItem($iResult_LV, $iIndex, $aResult[$i][$HSEL_RSLT_OUTERHTML], 1)
				_GUICtrlListView_AddSubItem($iResult_LV, $iIndex, $aResult[$i][$HSEL_RSLT_INNERHTML], 2)
				_GUICtrlListView_AddSubItem($iResult_LV, $iIndex, $aResult[$i][$HSEL_RSLT_INNERTEXT], 3)
			Next
			
			_GUICtrlListView_SetColumnWidth($iResult_LV, 0, -1)
			_GUICtrlListView_SetColumnWidth($iResult_LV, 1, 200)
			_GUICtrlListView_SetColumnWidth($iResult_LV, 2, 200)
			_GUICtrlListView_SetColumnWidth($iResult_LV, 3, 200)
			
			_StatusSet('Selected Items: ' & $aResult[0][0], 0x0000FF)
			_CtrlsSetState($GUI_ENABLE)
		Case $iGetAttribs_Bttn
			$aSelIndex = _GUICtrlListView_GetSelectedIndices($iResult_LV, True)
			
			If @error Or $aSelIndex[0] = 0 Then
				_StatusSet('No selected elements', 0xFF0000)
				ContinueLoop
			EndIf
			
			$aAttribs = $aResult[$aSelIndex[1] + 1][$HSEL_RSLT_ATTRIBS]
			
			If Not IsArray($aAttribs) Or $aAttribs[0][0] = 0 Then
				_StatusSet('Attributes not found', 0xFF0000)
				ContinueLoop
			EndIf
			
			$sAttribs = ''
			$sType = $aResult[$aSelIndex[1] + 1][$HSEL_RSLT_TYPE]
			
			For $i = 1 To $aAttribs[0][0]
				If $sAttribs Then
					$sAttribs &= @CRLF
				EndIf
				
				$sAttribs &= $aAttribs[$i][$HSEL_RSLTATTRB_NAME] & '=' & $aAttribs[$i][$HSEL_RSLTATTRB_VALUE]
			Next
			
			MsgBox(64, 'Attributes for ' & $sType & ' #' & $aSelIndex[1] + 1, $sAttribs, 0, $hGUI)
		Case $iLoadHtml_Bttn
			$sURL = InputBox('Load from URL', 'Enter URL to load Html from:', $sURL, '', -1, -1, Default, Default, 0, $hGUI)
			
			If StringRegExp($sURL, '^(?:https?://)?[^/\.]+\.[^\.]+') Then
				_StatusSet('Loading from URL (' & $sURL & ')', 0x0000FF, 0)
				_CtrlsSetState($GUI_DISABLE)
				_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($iResult_LV))
				
				If Not StringRegExp($sURL, '^https?://') Then
					$sURL = 'http://' & $sURL
				EndIf
				
				$sRead = BinaryToString(InetRead($sURL))
				
				If $sRead <> $sHTML Then
					$sHTML = $sRead
					
					$fLoadHtml_XPath = True
					$fLoadHtml_CSS = True
					
					GUICtrlSetData($iHtml_Edit, StringReplace(StringStripCR($sRead), @LF, @CRLF, 0, 2))
				EndIf
				
				_StatusSet('', 0x0000FF, 0)
				_CtrlsSetState($GUI_ENABLE)
			EndIf
	EndSwitch
WEnd

Func _Encoding_IsUTF8Format($sText, $iCheckASCIICode = False)
	Local $iAsc, $iExt, $iLen = StringLen($sText), $bLess128 = True
	
	For $i = 1 To $iLen
		$iAsc = Asc(StringMid($sText, $i, 1))
		
		If $iCheckASCIICode And $iAsc > 128 Then
			$bLess128 = False
		EndIf
		
		If Not BitAND($iAsc, 0x80) Then
			ContinueLoop
		ElseIf Not BitXOR(BitAND($iAsc, 0xE0), 0xC0) Then
			$iExt = 1
		ElseIf Not (BitXOR(BitAND($iAsc, 0xF0), 0xE0)) Then
			$iExt = 2
		ElseIf Not BitXOR(BitAND($iAsc, 0xF8), 0xF0) Then
			$iExt = 3
		Else
			Return False
		EndIf
		
		If $i + $iExt > $iLen Then
			Return False
		EndIf
		
		For $j = $i + 1 To $i + $iExt
			$iAsc = Asc(StringMid($sText, $j, 1))
			
			If BitXOR(BitAND($iAsc, 0xC0), 0x80) Then
				Return False
			EndIf
		Next
		
		$i += $iExt
	Next
	
	If $iCheckASCIICode Then
		Return ($bLess128 = False)
	EndIf
	
	Return True
EndFunc   ;==>_Encoding_IsUTF8Format

Func _StatusSet($sData, $nColor, $iTimer = 5000)
	GUICtrlSetColor($iStatus_Lbl, $nColor)
	GUICtrlSetData($iStatus_Lbl, $sData)
	
	If $iTimer Then
		AdlibRegister('_StatusClear', 5000)
	Else
		AdlibUnRegister('_StatusClear')
	EndIf
EndFunc

Func _StatusClear()
	AdlibUnRegister('_StatusClear')
	GUICtrlSetData($iStatus_Lbl, '')
EndFunc

Func _CtrlsSetState($iState)
	For $iID = $iFirstCtrlID To $iLastCtrlID
		If $iID <> $iStatus_Lbl And $iID <> $iStatus_Lbl - 1 Then
			GUICtrlSetState($iID, $iState)
		EndIf
	Next
EndFunc
